/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.relocations.com.mongodb.client.internal;

import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLContext;
import net.impactdev.impactor.relocations.com.mongodb.AutoEncryptionSettings;
import net.impactdev.impactor.relocations.com.mongodb.ClientEncryptionSettings;
import net.impactdev.impactor.relocations.com.mongodb.MongoClientException;
import net.impactdev.impactor.relocations.com.mongodb.MongoClientSettings;
import net.impactdev.impactor.relocations.com.mongodb.MongoNamespace;
import net.impactdev.impactor.relocations.com.mongodb.client.MongoClients;
import net.impactdev.impactor.relocations.com.mongodb.client.internal.CollectionInfoRetriever;
import net.impactdev.impactor.relocations.com.mongodb.client.internal.CommandMarker;
import net.impactdev.impactor.relocations.com.mongodb.client.internal.Crypt;
import net.impactdev.impactor.relocations.com.mongodb.client.internal.KeyManagementService;
import net.impactdev.impactor.relocations.com.mongodb.client.internal.KeyRetriever;
import net.impactdev.impactor.relocations.com.mongodb.client.internal.SimpleMongoClient;
import net.impactdev.impactor.relocations.com.mongodb.client.internal.SimpleMongoClients;
import net.impactdev.impactor.relocations.com.mongodb.crypt.capi.MongoCryptOptions;
import net.impactdev.impactor.relocations.com.mongodb.crypt.capi.MongoCrypts;
import net.impactdev.impactor.relocations.com.mongodb.internal.capi.MongoCryptHelper;

public final class Crypts {
    public static Crypt createCrypt(SimpleMongoClient client, AutoEncryptionSettings options) {
        return new Crypt(MongoCrypts.create((MongoCryptOptions)MongoCryptHelper.createMongoCryptOptions(options.getKmsProviders(), options.getSchemaMap())), new CollectionInfoRetriever(client), new CommandMarker(options.isBypassAutoEncryption(), options.getExtraOptions()), Crypts.createKeyRetriever(client, options.getKeyVaultMongoClientSettings(), options.getKeyVaultNamespace()), Crypts.createKeyManagementService(), options.isBypassAutoEncryption());
    }

    static Crypt create(SimpleMongoClient keyVaultClient, ClientEncryptionSettings options) {
        return new Crypt(MongoCrypts.create((MongoCryptOptions)MongoCryptHelper.createMongoCryptOptions(options.getKmsProviders(), null)), Crypts.createKeyRetriever(keyVaultClient, false, options.getKeyVaultNamespace()), Crypts.createKeyManagementService());
    }

    private static KeyRetriever createKeyRetriever(SimpleMongoClient defaultKeyVaultClient, MongoClientSettings keyVaultMongoClientSettings, String keyVaultNamespaceString) {
        boolean keyRetrieverOwnsClient;
        SimpleMongoClient keyVaultClient;
        if (keyVaultMongoClientSettings != null) {
            keyVaultClient = SimpleMongoClients.create(MongoClients.create(keyVaultMongoClientSettings));
            keyRetrieverOwnsClient = true;
        } else {
            keyVaultClient = defaultKeyVaultClient;
            keyRetrieverOwnsClient = false;
        }
        return Crypts.createKeyRetriever(keyVaultClient, keyRetrieverOwnsClient, keyVaultNamespaceString);
    }

    private static KeyRetriever createKeyRetriever(SimpleMongoClient keyVaultClient, boolean keyRetrieverOwnsClient, String keyVaultNamespaceString) {
        return new KeyRetriever(keyVaultClient, keyRetrieverOwnsClient, new MongoNamespace(keyVaultNamespaceString));
    }

    private static KeyManagementService createKeyManagementService() {
        return new KeyManagementService(Crypts.getSslContext(), 443, 10000);
    }

    private static SSLContext getSslContext() {
        SSLContext sslContext;
        try {
            sslContext = SSLContext.getDefault();
        }
        catch (NoSuchAlgorithmException e) {
            throw new MongoClientException("Unable to create default SSLContext", e);
        }
        return sslContext;
    }

    private Crypts() {
    }
}

